#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include "gamegen.h"

#ifdef __GNUC__
#include <unistd.h>
#include <getopt.h>
#else
#include "getopt.c"
#endif

/* (C) Copyright 1996-1998 David McGrath (pat@snowfox.fur.com)
   Based on a Pascal program (C) Copyright 1994 David McGrath
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef __GNUC__
extern int getopt (int, char *[], const char *);
extern const char *optarg;
#endif

static codesize codestruct;

/***************************************************************************/
void givevers(void)
{
    printf("version " GAMEGENVER "\n");
}

/***************************************************************************/
#ifdef __GNUC__
static inline void givehelp(char progname[])
#else
static void givehelp(char progname[])
#endif
{
    printf("usage:  %s [-b] [-c] "
#ifdef OPCODE
	   "[-e] "		/* autostrcat.  ANSI C is so useful! */
#endif
	   "[-f filename] "
#ifdef OPCODE
	   "[-F filename] "
#endif
	   "[-g] [-h] "
#ifdef OPCODE
	   "[-o] "
#endif
	   "[-s] [-v] [-x] [--] code [code...]\n\n"
	   "\tb:\tbugfix for different versions of the Game Genie(TM)\n"
	   "\tc:\tcancel effects of -g and -x\n"
#ifdef OPCODE
	   "\te:\tend listing of opcodes\n"
#endif
	   "\tf:\tscan text file <filename> for codes\n"
#ifdef OPCODE
	   "\tF:\tscan binary file <filename> taking bytes as codes\n"
#endif
	   "\tg:\tforce Game Genie(TM) code\t(xxxx-xxxx)\n"
	   "\th:\tdisplay this help\n"
#ifdef OPCODE
	   "\to:\tshow 65c816 opcodes\n"
#endif
	   "\ts:\tsuppress copyright info\n"
	   "\tv:\tshow version\n"
	   "\tx:\tforce hexadecimal code\t\t(xx:xxxxxx)\n"
	   "\t-:\tignores all subsequent options and codes\n"
	   "\nSee README for more help.\n\n", progname);
}

/***************************************************************************/
void Make8Struct(char string8[])

{
    int i = 0, j = 0;
    gameflags |= GOTCODE;
    if (!(gameflags & (FORCE_GG + FORCEHEX))) {
	if (!(gameflags & NOERRORS)) {
	printf(INCFORMERR, string8);
	exit(EXIT_FAILURE);
	}
    }
    strcpy(codestruct, string8);
    for (i = 0; i <= 7; i++) {
	if (isxdigit(string8[i]))
	    codestruct[j++] = codestruct[i];
    }
    codestruct[j] = '\0';	/* Ah'll be baahk... */
    if (j != 8) {
	if (!(gameflags & NOERRORS)) {
		printf(NEED8ERR, j, string8);
		exit(EXIT_FAILURE);
	}
    }
    gameflags = (gameflags & FORCE_GG) ? (gameflags | IS_GG) : gameflags;
}

/***************************************************************************/
void Make9Struct(char string9[])
{
    int i = 0, j = 0;
    gameflags |= GOTCODE;	/* It is 'til it ain't. */
    strcpy(codestruct, string9);
    for (i = 0; i <= 8; i++) {	/* if-else spaghetti.  Yum! */
	if (isxdigit(string9[i]))
	    codestruct[j++] = codestruct[i];
	else if (string9[i] == '-') {
		 if (i == 4)
			gameflags |= IS_GG + GOTPUNCTUATION;
	    else if (gameflags & NOERRORS)
			gameflags &= ~GOTCODE;
		else {
			printf(INCFORMERR, string9);
			exit(EXIT_FAILURE);
		}
	}
	if (string9[i] == ':') {
	    if (i == 2) {
		gameflags &= ~IS_GG;
		gameflags |= GOTPUNCTUATION;
	    } else if (gameflags & NOERRORS)
			gameflags &= ~GOTCODE;
		else {
			printf(INCFORMERR, string9);
			exit(EXIT_FAILURE);
	    }
	}
    }
    codestruct[j] = '\0';	/* Ah sed ah'd be bahhk... */
    if (j != 8) {
	if (gameflags & NOERRORS)
		gameflags &= ~GOTCODE;
	else {
		printf(NEED8ERR, j, string9);
		exit(EXIT_FAILURE);
	}
    }
    if (!(gameflags & GOTPUNCTUATION)) {
	if (gameflags & NOERRORS) 
		gameflags &= ~GOTCODE;
	else {
		printf(INCFORMERR, string9);
		exit(EXIT_FAILURE);	/* Stop stuff like 1234*5678 */
	}
    }
    if (gameflags & (FORCE_GG + FORCEHEX))
	gameflags = ((gameflags & FORCE_GG) ? (gameflags | IS_GG) : (gameflags & ~IS_GG));
}

/***************************************************************************/
void ConvertCode(void)
/* this is where the program spends most of its time... */
{
    int i = 0;
    unsigned long int CodeNum = 0, result = 0;
				 /* 0123456789ABCDEF */
    static const char ggString[] = "DF4709156BC8A23E";
    static const char hxString[] = "46DE2783B5C9A0F1";
    if (gameflags & IS_GG) {
	char tempch[2];		/* Is there a better way to do this? */
	tempch[1] = '\0';	/* Ah'll be... oh, wait, that's been done */
	for (i = 0; i <= 7; i++) {
	    tempch[0] = codestruct[i];
//	    sscanf(tempch, "%c", &codestruct[i]);
	    codestruct[i] = hxString[strtol(tempch, NULL, 16)];
	}
	sscanf(codestruct, "%lX", &CodeNum);
	/* 
	 *    255 == 11111111; 15 == 1111; 3 == 11
	 */
	/*  1- 7 ==>  1- 7 */ result += (CodeNum & (255UL << 24)) >>  0;
	/*  8-11 ==> 16-19 */ result += (CodeNum & ( 15UL << 20)) >>  8;
	/* 12-15 ==> 24-27 */ result += (CodeNum & ( 15UL << 16)) >> 12;
	/* 16-17 ==> 22-23 */ result += (CodeNum & (  3UL << 14)) >>  6;
	/* 18-21 ==>  8-11 */ result += (CodeNum & ( 15UL << 10)) << 10;
	/* 22-25 ==> 28-31 */ result += (CodeNum & ( 15UL <<  6)) >>  6;
	/* 26-29 ==> 12-15 */ result += (CodeNum & ( 15UL <<  2)) << 14;
	/* 30-31 ==> 20-21 */ result += (CodeNum & (  3UL <<  0)) << 10;
	if (gameflags & DOFIX)
	   result = (result ^ (1UL << 15)); /* 0x8000 */
#ifdef OPCODE
	if (gameflags & SHOWOPCODE)
	    ShowOpCode(result);
	else
#endif	/* OPCODE */
	printf("%0.2X:%0.6lX\n", (int) ((result & (255UL << 24)) >> 24), (result & ((1UL << 24) - 1)));
    } else {
	sscanf(codestruct, "%lX", &CodeNum);
#ifdef OPCODE
	if (gameflags & SHOWOPCODE)
	    ShowOpCode(CodeNum);
	else {
#endif	/* OPCODE */
	/*  1- 7 ==>  1- 7 */ result += (CodeNum & (255UL << 24)) >>  0;
	/*  8-11 ==> 18-21 */ result += (CodeNum & ( 15UL << 20)) >> 10;
	/* 12-15 ==> 26-29 */ result += (CodeNum & ( 15UL << 16)) >> 14;
	/* 16-19 ==>  8-11 */ result += (CodeNum & ( 15UL << 12)) <<  8;
	/* 20-21 ==> 30-31 */ result += (CodeNum & (  3UL << 10)) >> 10;
	/* 22-23 ==> 16-17 */ result += (CodeNum & (  3UL <<  8)) <<  6;
	/* 24-27 ==> 12-15 */ result += (CodeNum & ( 15UL <<  4)) << 12;
	/* 28-31 ==> 22-25 */ result += (CodeNum & ( 15UL <<  0)) <<  6;
        if (gameflags & DOFIX)
           result = (result ^ (1UL << 23)); /* 0x800000 */
	for (i = 7; i >= 0; i--) {
		printf("%c", ggString[((result & (15UL << i * 4)) >> i * 4)]);
		if (i == 4)
		    printf("-");
	}
	printf("\n");
#ifdef OPCODE
	}
#endif	/* OPCODE */
    }
}

#ifdef OPCODE
/***************************************************************************/
void ShowOpCode(unsigned long int result)
{
    unsigned char data = 0;
    long int address = 0;
    data = (result & (255UL << 24)) >> 24;	/* FF000000 */
    address = result & ((1UL << 24) - 1);	/* 00FFFFFF == 1000000 - 1 */
    printf("%0.2X:%0.6lX:  ", data, address);
    switch (data) {
    case 0x00:
	printf("BRK #xx -- breakpoint instruction (char) xx[?]\n");
	break;
    case 0x01:
	printf("ORA (xx,X) -- OR A with data in address xx, indexed by X\n");
	break;
    case 0x02:
	printf("COP #xx -- call system procedure (char) xx\n");
	break;
    case 0x03:
	printf("ORA xx,S -- OR S with xx\n");
	break;
    case 0x04:
	printf("TSB xx -- test and set bit in xx\n");
	break;
    case 0x05:
	printf("ORA xx -- OR A with xx\n");
	break;
    case 0x06:
	printf("ASL xx -- shift A left xx bits\n");
	break;
    case 0x07:
	printf("ORA [xx] -- OR A with (short int) xx\n");
	break;
    case 0x08:
	printf("PHP -- push P\n");
	break;
    case 0x09:
	printf("ORA #xx(xx) -- OR A with (char) xx(xx)\n");
	break;
    case 0x0A:
	printf("ASL -- shift A left\n");
	break;
    case 0x0B:
	printf("PHD -- push D\n");
	break;
    case 0x0C:
	printf("TSB xxxx -- test and set bit in xxxx\n");
	break;
    case 0x0D:
	printf("ORA xxxx -- OR A with xxxx\n");
	break;
    case 0x0E:
	printf("ASL xxxx -- shift A left xxxx bits\n");
	break;
    case 0x0F:
	printf("ORA xxxxxx -- shift A left xxxxxx bits\n");
	break;
    case 0x10:
	printf("BPL xx -- branch to 0x%0.6lX - (0xFE - xx) if positive\n", address);
	break;
    case 0x11:
	printf("ORA (xx), Y -- OR Y with data in address xx\n");
	break;
    case 0x12:
	printf("ORA (xx) -- OR A with data in address xx\n");
	break;
    case 0x13:
	printf("ORA (xx, S), Y -- OR Y with data in address xx, indexed by S\n");
	break;
    case 0x14:
	printf("TRB xx -- test and remove bit in A with xx\n");
	break;
    case 0x15:
	printf("ORA xx, X -- OR X with xx\n");
	break;
    case 0x16:
	printf("ASL xx, X -- shift X left xx bits\n");
	break;
    case 0x17:
	printf("ORA [xx], Y -- OR Y with (short int) xx\n");
	break;
    case 0x18:
	printf("CLC -- clear the carry flag\n");
	break;
    case 0x19:
	printf("ORA xxxx, Y -- OR Y with xxxx\n");
	break;
    case 0x1A:
	printf("INC -- increment A\n");
	break;
    case 0x1B:
	printf("INZ -- increment then zero A[?!?]\n");
	break;
    case 0x1C:
	printf("TRB xxxx -- test and remove bit in A with xxxx\n");
	break;
    case 0x1D:
	printf("ORA xxxx, X -- OR X with xxxx\n");
	break;
    case 0x1E:
	printf("ASL xxxx, X -- shift X left xxxx bits\n");
	break;
    case 0x1F:
	printf("ORA xxxxxx, X -- OR X with xxxxxx\n");
	break;
    case 0x20:
	printf("JSR xxxx -- jump to subroutine xxxx\n");
	break;
    case 0x21:
	printf("AND (xx, X) -- AND A with data in address xx, indexed by X\n");
	break;
    case 0x22:
	printf("JSL xxxxxx -- long jump to subroutine xxxxxx\n");
	break;
    case 0x23:
	printf("AND xx, S -- AND S with xx\n");
	break;
    case 0x24:
	printf("BIT xx -- test bits in A with xx\n");
	break;
    case 0x25:
	printf("AND xx -- AND A with xx\n");
	break;
    case 0x26:
	printf("ROL xx -- rotate A left xx bits\n");
	break;
    case 0x27:
	printf("AND [xx] -- AND A with (short int) xx\n");
	break;
    case 0x28:
	printf("PLP -- pop P\n");
	break;
    case 0x29:
	printf("AND #xx(xx) -- AND A with (char) xx(xx)\n");
	break;
    case 0x2A:
	printf("ROL -- rotate A left\n");
	break;
    case 0x2B:
	printf("PLD -- pop operand in D\n");
	break;
    case 0x2C:
	printf("BIT xxxx -- test bits in A with xxxx\n");
	break;
    case 0x2D:
	printf("AND xxxx -- AND A with xxxx\n");
	break;
    case 0x2E:
	printf("ROL xxxx -- rotate A left xxxx bits.\n");
	break;
    case 0x2F:
	printf("AND xxxxxx -- AND A with xxxxxx\n");
	break;
    case 0x30:
	printf("BMI xx -- branch to 0x%0.6lX - (0xFE - xx) if negative\n", address);
	break;
    case 0x31:
	printf("AND (xx), Y -- AND Y with data in address xx\n");
	break;
    case 0x32:
	printf("AND (xx) -- AND A with data in address xx\n");
	break;
    case 0x33:
	printf("AND (xx, S), Y -- AND Y with data in address xx, indexed by S\n");
	break;
    case 0x34:
	printf("BIT xx, X -- test bits in X with xx\n");
	break;
    case 0x35:
	printf("AND xx, X -- AND X with xx\n");
	break;
    case 0x36:
	printf("ROL xx, X -- rotate X left xx bits\n");
	break;
    case 0x37:
	printf("AND [xx], Y -- AND Y with (short int) xx\n");
	break;
    case 0x38:
	printf("SEC -- set carry flag\n");
	break;
    case 0x39:
	printf("AND xxxx, Y -- AND Y with xxxx\n");
	break;
    case 0x3A:
	printf("DEC -- decrement A\n");
	break;
    case 0x3B:
	printf("TSC -- transfer S to A\n");
	break;
    case 0x3C:
	printf("BIT xxxx, X -- test bits in X with xxxx\n");
	break;
    case 0x3D:
	printf("AND xxxx, X -- AND X with xxxx\n");
	break;
    case 0x3E:
	printf("ROL xxxx, X -- rotate X left xxxx bits\n");
	break;
    case 0x3F:
	printf("AND xxxxxx, X -- AND X with xxxxxx\n");
	break;
    case 0x40:
	printf("RTI -- return from interrupt\n");
	break;
    case 0x41:
	printf("EOR (xx, X) -- XOR A with xx, indexed by X\n");
	break;
    case 0x42:
	printf("NEG -- negate bits in A [?]\n");
	break;
    case 0x43:
	printf("EOR xx, S -- XOR S with xx\n");
	break;
    case 0x44:
	printf("MVP xxxx -- block move xxxx to A and increment\n");
	break;
    case 0x45:
	printf("EOR xx -- XOR A with xx\n");
	break;
    case 0x46:
	printf("LSR xx -- rotate A right xx bits\n");
	break;
    case 0x47:
	printf("EOR [xx] -- XOR A with data in address xx\n");
	break;
    case 0x48:
	printf("PHA -- push A\n");
	break;
    case 0x49:
	printf("EOR #xx(xx) -- XOR A with (short int) xx(xx)\n");
	break;
    case 0x4A:
	printf("LSR -- rotate A right\n");
	break;
    case 0x4B:
	printf("PHK -- push direct page bank register\n");
	break;
    case 0x4C:
	printf("JMP xxxx -- absolute jump to address xxxx\n");
	break;
    case 0x4D:
	printf("EOR xxxx -- XOR A with xxxx\n");
	break;
    case 0x4E:
	printf("LSR xxxx -- rotate A right xxxx bits\n");
	break;
    case 0x4F:
	printf("EOR xxxxxx -- XOR A with xxxxxx\n");
	break;
    case 0x50:
	printf("BVC xx -- branch to 0x%0.6lX - (0xFE - xx) if overflow bit is clear\n", address);
	break;
    case 0x51:
	printf("EOR (xx), Y -- XOR Y with data in address xx\n");
	break;
    case 0x52:
	printf("EOR (xx) -- XOR A with data in address xx\n");
	break;
    case 0x53:
	printf("EOR (xx, S), Y -- XOR Y with data in address xx, indexed by S\n");
	break;
    case 0x54:
	printf("MVN xxxx -- block move xxxx and decrement\n");
	break;
    case 0x55:
	printf("EOR xx, X -- XOR X with xx\n");
	break;
    case 0x56:
	printf("LSR xx, X -- rotate X right xx bits\n");
	break;
    case 0x57:
	printf("EOR [xx], Y -- XOR Y with data in address (short int) xx\n");
	break;
    case 0x58:
	printf("CLI -- clear the interrupt flag\n");
	break;
    case 0x59:
	printf("EOR xxxx, Y -- XOR Y with xxxx\n");
	break;
    case 0x5A:
	printf("PHY -- push Y\n");
	break;
    case 0x5B:
	printf("TCD -- transfer A to D\n");
	break;
    case 0x5C:
	printf("JMP xxxxxx -- absolute jump to address xxxxxx\n");
	break;
    case 0x5D:
	printf("EOR xxxx, X -- XOR X with xxxx\n");
	break;
    case 0x5E:
	printf("LSR xxxx, X -- rotate X right xxxx bits\n");
	break;
    case 0x5F:
	printf("XOR xxxxxx, X -- XOR X with xxxxxx\n");
	break;
    case 0x60:
	printf("RTS -- return from short subroutine\n");
	break;
    case 0x61:
	printf("ADC (xx, X) -- add data in address xx (indexed by X) to A, with carry\n");
	break;
    case 0x62:
	printf("PER xx -- push relative address 0x%0.6lX - (0xFE - xx)\n", address);
	break;
    case 0x63:
	printf("ADC xx, S -- add xx to S with carry\n");
	break;
    case 0x64:
	printf("STZ xx -- zero A with bitmap xx\n");
	break;
    case 0x65:
	printf("ADC xx -- add xx to A with carry\n");
	break;
    case 0x66:
	printf("ROR xx -- rotate A right xx bits\n");
	break;
    case 0x67:
	printf("ADC [xx] -- add (short int) xx to A, with carry\n");
	break;
    case 0x68:
	printf("PLA -- pop A\n");
	break;
    case 0x69:
	printf("ADC #xx(xx) -- add (char) xx(xx) to A with carry\n");
	break;
    case 0x6A:
	printf("ROR -- rotate A right\n");
	break;
    case 0x6B:
	printf("RTL -- return from long subroutine\n");
	break;
    case 0x6C:
	printf("JMP (xxxx) -- jump to address held in address xxxx\n");
	break;
    case 0x6D:
	printf("ADC xxxx -- add xxxx to A with carry\n");
	break;
    case 0x6E:
	printf("ROR xxxx -- rotate A right xxxx bits\n");
	break;
    case 0x6F:
	printf("ADC xxxxxx -- add xxxxxx to A with carry\n");
	break;
    case 0x70:
	printf("BVS xx -- branch to address 0x%0.6lX - (0xFE - xx) if overflow set\n", address);
	break;
    case 0x71:
	printf("ADC (xx), Y -- add data in address xx to Y\n");
	break;
    case 0x72:
	printf("ADC (xx) -- add data in address xx to A\n");
	break;
    case 0x73:
	printf("ADC (xx, S), Y -- add data in address xx to Y, indexed by S\n");
	break;
    case 0x74:
	printf("STZ xx, X -- zero X with bitmap xx\n");
	break;
    case 0x75:
	printf("ADC xx, X -- add xx to X with carry\n");
	break;
    case 0x76:
	printf("ROR xx, X -- rotate X right xx bits\n");
	break;
    case 0x77:
	printf("ADC [xx], Y -- add (short int) xx to Y\n");
	break;
    case 0x78:
	printf("SEI -- set interrupt flag\n");
	break;
    case 0x79:
	printf("ADC xxxx, Y -- add xxxx to Y with carry\n");
	break;
    case 0x7A:
	printf("PLY -- pop Y\n");
	break;
    case 0x7B:
	printf("TDC -- tranfer D to A\n");
	break;
    case 0x7C:
	printf("JMP (xxxx, X) -- jump to address xxxx, indexed by X\n");
	break;
    case 0x7D:
	printf("ADC xxxx, X -- add xxxx to X with carry\n");
	break;
    case 0x7E:
	printf("ROR xxxx, X -- rotate X right xxxx bits\n");
	break;
    case 0x7F:
	printf("ADC xxxxxx, X -- add xxxxxx to X with carry\n");
	break;			/* Half done */
    case 0x80:
	printf("BRA xx -- short branch to address 0x%0.6lX - (0xFE - xx)\n", address);
	break;
    case 0x81:
	printf("STA (xx, X) -- store data in address xx in A, indexed by X\n");
	break;
    case 0x82:
	printf("BRL xx -- long branch to address 0x%0.6lX - (0xFE - xx)\n", address);
	break;
    case 0x83:
	printf("STA xx, S -- store xx in S, store in A[?]\n");
	break;
    case 0x84:
	printf("STY xx -- store xx in Y\n");
	break;
    case 0x85:
	printf("STA xx -- store xx in A\n");
	break;
    case 0x86:
	printf("STX xx -- store xx in X\n");
	break;
    case 0x87:
	printf("STA [xx] -- store (short int) xx in A\n");
	break;
    case 0x88:
	printf("DEY -- decrement Y\n");
	break;
    case 0x89:
	printf("BIT #xx(xx) -- test bits in A with (char) xx(xx)\n");
	break;
    case 0x8A:
	printf("TXA -- transfer X to A\n");
	break;
    case 0x8B:
	printf("PHB -- push data bank register\n");
	break;
    case 0x8C:
	printf("STY xxxx -- store xxxx in Y\n");
	break;
    case 0x8D:
	printf("STA xxxx -- store xxxx in A\n");
	break;
    case 0x8E:
	printf("STX xxxx -- store xxxx in X\n");
	break;
    case 0x8F:
	printf("STA xxxxxx -- store xxxxxx in A\n");
	break;
    case 0x90:
	printf("BCC xx -- branch to address 0x%0.6lX - (0xFE - xx) if carry bit clear\n", address);
	break;
    case 0x91:
	printf("STA (xx), Y -- store data in address xx in A, put in Y[?]\n");
	break;
    case 0x92:
	printf("STA (xx) -- store data in address xx in A\n");
	break;
    case 0x93:
	printf("STA (xx, S), Y -- store xx in Y, put in A, indexed by S[?]\n");
	break;
    case 0x94:
	printf("STY xx, X -- store xx in Y, put in X\n");
	break;
    case 0x95:
	printf("STA xx, X -- store xx in A, put in X\n");
	break;
    case 0x96:
	printf("STX xx, Y -- store xx in X, put in Y\n");
	break;
    case 0x97:
	printf("STA [xx], Y -- store data in address xx in A, put in Y\n");
	break;
    case 0x98:
	printf("TYA -- transfer Y to A\n");
	break;
    case 0x99:
	printf("STA xxxx, Y -- store xxxx in A, put in Y\n");
	break;
    case 0x9A:
	printf("TXS -- transfer X to S\n");
	break;
    case 0x9B:
	printf("TXY -- transfer X to Y\n");
	break;
    case 0x9C:
	printf("STZ xxxx -- zero A with bitmap xxxx\n");
	break;
    case 0x9D:
	printf("STA xxxx, X -- store xxxx in A, put in X\n");
	break;
    case 0x9E:
	printf("STZ xxxx, X -- zero X with bitmap xxxx\n");
	break;
    case 0x9F:
	printf("STA xxxxxx, X -- store xxxxxx in A, put in X\n");
	break;
    case 0xA0:
	printf("LDY #xx(xx) -- load Y with (char) xx(xx)\n");
	break;
    case 0xA1:
	printf("LDA (xx, X) -- load A with xx, indexed by X\n");
	break;
    case 0xA2:
	printf("LDX #xx(xx) -- load X with (char) xxxx\n");
	break;
    case 0xA3:
	printf("LDA xx, S -- load A with xx, put in S\n");
	break;
    case 0xA4:
	printf("LDY xx -- load Y with xx\n");
	break;
    case 0xA5:
	printf("LDA xx -- load A with xx\n");
	break;
    case 0xA6:
	printf("LDX xx -- load X with xx\n");
	break;
    case 0xA7:
	printf("LDA [xx] -- load A with (short int) xx\n");
	break;
    case 0xA8:
	printf("TAY -- transfer A to Y\n");
	break;
    case 0xA9:
	printf("LDA #xx(xx) -- load A with (char) xx(xx)\n");
	break;
    case 0xAA:
	printf("TAX -- transfer A to X\n");
	break;
    case 0xAB:
	printf("PLB -- pull direct page bank register\n");
	break;
    case 0xAC:
	printf("LDY xxxx -- load Y with xxxx\n");
	break;
    case 0xAD:
	printf("LDA xxxx -- load A with xxxx\n");
	break;
    case 0xAE:
	printf("LDX xxxx -- load X with xxxx\n");
	break;
    case 0xAF:
	printf("LDA xxxxxx -- load A with xxxxxx\n");
	break;
    case 0xB0:
	printf("BCS xx -- branch to address 0x%0.6lX - (0xFE - xx) if carry bit set\n", address);
	break;
    case 0xB1:
	printf("LDA (xx), Y -- load A with data in address xx, store in Y\n");
	break;
    case 0xB2:
	printf("LDA (xx) -- load A with data in address xx\n");
	break;
    case 0xB3:
	printf("LDA (xx, S), Y -- load A with data in xx, indexed by S, store in Y\n");
	break;
    case 0xB4:
	printf("LDY xx, X -- load Y with xx, store in X\n");
	break;
    case 0xB5:
	printf("LDA xx, X -- load A with xx, store in X\n");
	break;
    case 0xB6:
	printf("LDX xx, Y -- load X with xx, store in Y\n");
	break;
    case 0xB7:
	printf("LDA [xx], Y -- load A with (short int) xx, store in Y\n");
	break;
    case 0xB8:
	printf("CLV -- clear V bit [overflow?  unsure]\n");
	break;
    case 0xB9:
	printf("LDA xxxx, Y -- load A with xxxx, store in Y\n");
	break;
    case 0xBA:
	printf("TSX -- transfer S to X\n");
	break;
    case 0xBB:
	printf("LDZ xxxx, X -- load Z with xxxx, store in X[?]\n");
	break;
    case 0xBC:
	printf("LDY xxxx, X -- load Y with xxxx, store in X\n");
	break;
    case 0xBD:
	printf("LDA xxxx, X -- load A with xxxx, store in X\n");
	break;
    case 0xBE:
	printf("LDX xxxx, Y -- load X with xxxx, store in Y\n");
	break;
    case 0xBF:
	printf("LDA xxxxxx, X -- load A with xxxxxx, store in X\n");
	break;
    case 0xC0:
	printf("CPY #xx(xx) -- compare Y to (char) xx(xx)\n");
	break;
    case 0xC1:
	printf("CMP (xx, X) -- compare A to data in address xx, indexed by X\n");
	break;
    case 0xC2:
	printf("REP/CLP xx -- clear bits in P\n");
	break;
    case 0xC3:
	printf("CMP xx, S -- compare A to xx, store in S\n");
	break;
    case 0xC4:
	printf("CPY xx -- compare Y to xx\n");
	break;
    case 0xC5:
	printf("CMP xx -- compare A to xx\n");
	break;
    case 0xC6:
	printf("DEC xx -- decrement A by xx\n");
	break;
    case 0xC7:
	printf("CMP [xx] -- compare A to data in address xx\n");
	break;
    case 0xC8:
	printf("INY -- increment Y\n");
	break;
    case 0xC9:
	printf("CMP #xx(xx) -- compare A to (char) xx(xx)\n");
	break;
    case 0xCA:
	printf("DEX -- decrement X\n");
	break;
    case 0xCB:
	printf("WAI -- wait for interrupt\n");
	break;
    case 0xCC:
	printf("CPY xxxx -- compare Y to xxxx\n");
	break;
    case 0xCD:
	printf("CMP xxxx -- compare A to xxxx\n");
	break;
    case 0xCE:
	printf("DEC xxxx -- decrement A by xxxx\n");
	break;
    case 0xCF:
	printf("CMP xxxxxx -- compare A to aaaaaa\n");
	break;
    case 0xD0:
	printf("BNE xx -- branch to address 0x%0.6lX - (0xFE - xx) if not equal\n", address);
	break;
    case 0xD1:
	printf("CMP (xx), Y -- compare Y to data in address xx\n");
	break;
    case 0xD2:
	printf("CMP (xx) -- compare A to data in address xx\n");
	break;
    case 0xD3:
	printf("CMP (xx, S), Y -- compare Y to data in address xx, indexed by S\n");
	break;
    case 0xD4:
	printf("PEI (xx) -- push data in local address xx\n");
	break;
    case 0xD5:
	printf("CMP xx, X -- compare X to xx\n");
	break;
    case 0xD6:
	printf("DEC xx, X -- decrement X by xx\n");
	break;
    case 0xD7:
	printf("CMP [xx], Y -- compare Y to (short int) xx\n");
	break;
    case 0xD8:
	printf("CLD -- clear decimal flag\n");
	break;
    case 0xD9:
	printf("CMP xxxx, Y -- compare Y to xxxx\n");
	break;
    case 0xDA:
	printf("PHX -- push X\n");
	break;
    case 0xDB:
	printf("STP/HLT -- stop/halt the clock\n");
	break;
    case 0xDC:
	printf("JML xxxx -- long jump to address xxxx\n");
	break;
    case 0xDD:
	printf("CMP xxxx, X -- compare X to xxxx\n");
	break;
    case 0xDE:
	printf("DEC xxxx, X -- decrement X by xxxx\n");
	break;
    case 0xDF:
	printf("CMP xxxxxx, X -- compare X to xxxxxx\n");
	break;
    case 0xE0:
	printf("CPX #xx(xx) -- compare X to (char) xx(xx)\n");
	break;
    case 0xE1:
	printf("SBC (xx, X) -- subtract xx from X with carry\n");
	break;
    case 0xE2:
	printf("SEP xx -- set bits in P\n");
	break;
    case 0xE3:
	printf("SBC xx, S -- subtact xx from S with carry\n");
	break;
    case 0xE4:
	printf("CPX xx -- compare X to xx\n");
	break;
    case 0xE5:
	printf("SBC xx -- subtract xx from A with carry\n");
	break;
    case 0xE6:
	printf("INC xx -- increment A\n");
	break;
    case 0xE7:
	printf("SBC [xx] -- subtract (short int) xx from A with carry\n");
	break;
    case 0xE8:
	printf("INX -- increment X\n");
	break;
    case 0xE9:
	printf("SBC #xx(xx) -- subtract (char) xx(xx) from A with carry\n");
	break;
    case 0xEA:
	printf("NOP -- no operation\n");
	break;
    case 0xEB:
	printf("XBA/SWA -- swap accumulator halves\n");
	break;
    case 0xEC:
	printf("CPX xxxx -- compare X to xxxx\n");
	break;
    case 0xED:
	printf("SBC xxxx -- subtract xxxx from A\n");
	break;
    case 0xEE:
	printf("INC xxxx -- increment A by xxxx\n");
	break;
    case 0xEF:
	printf("SBC xxxxxx -- subtract xxxxxx from A\n");
	break;
    case 0xF0:
	printf("BEQ xx -- branch to address 0x%0.6lX - (0xFE - xx) if equal\n", address);
	break;
    case 0xF1:
	printf("SBC (xx), Y -- subtract data in address xx from Y\n");
	break;
    case 0xF2:
	printf("SBC (xx) -- subtract data in address xx from A\n");
	break;
    case 0xF3:
	printf("SBC (xx, S), Y -- subtract data in address xx (indexed by S) from Y\n");
	break;
    case 0xF4:
	printf("PEA xxxx -- push (char) xxxx\n");
	break;
    case 0xF5:
	printf("SBC xx, X -- subtract xx from X\n");
	break;
    case 0xF6:
	printf("INC xx, X -- increment X by xx\n");
	break;
    case 0xF7:
	printf("SBC [xx], Y -- subtract (short int) xx from Y\n");
	break;
    case 0xF8:
	printf("SED -- set decimal flag\n");
	break;
    case 0xF9:
	printf("SBC xxxx, Y -- subtract xxxx from Y\n");
	break;
    case 0xFA:
	printf("PLX -- pop X\n");
	break;
    case 0xFB:
	printf("XCE -- exchange carry and emulation bits\n");
	break;
    case 0xFC:
	printf("JSR (xxxx, X) -- jump to subroutine xxxx, indexed by X\n");
	break;
    case 0xFD:
	printf("SBC xxxx, X -- subtract xxxx from X\n");
	break;
    case 0xFE:
	printf("INC xxxx, X -- increment X by xxxx\n");
	break;
    case 0xFF:
	printf("SBC xxxxxx, X -- subtract xxxxxx from X\n");
	break;
    default:
	printf(OPCODEERR, data);
	exit(EXIT_FAILURE);

/* I'm not quite sure about 1B (INZ), 42 (NEG), 4A (LSR A), and
   BB (LDZ xxxx, X), nor about the left and right shift by bits
   stuff, (e.g. LSR xx) not to mention other things.  As well, 
   what's CLV? */
    }
}
#endif	/* OPCODE */

/******************************************************************/

#ifdef OPCODE
void bitTrans(FILE *stream)
{
	long int address = 0, byte = 0;
	for (;;) {
		byte = fgetc(stream);
		if (byte == EOF)
			return;
		ShowOpCode((address++ & ((1UL << 24) - 1)) + (byte << 24));
	}
}
#endif	/* OPCODE */
/******************************************************************/
void punctGrep(FILE *stream)
{
    char *filechunk = malloc(MAXLINESIZE), tempcode[10];
    long int linesize = 0, i = 0, j = 0, tophalf = 0, bottomhalf = 0;
    gameflags |= NOERRORS;
    while (fgets(filechunk, MAXLINESIZE - 1, stream) != 0) {
	linesize = strlen(filechunk);
	if ((strchr(filechunk, ':') != 0) |
	    (strchr(filechunk, '-') != 0)) { /* Save some time */
		for (i = 0; i <= linesize - 10; i++) {
			for (j = 0; j <= 8; j++)
				tempcode[j] = filechunk[i+j];
			tempcode[j] = '\0';
			if ((sscanf(tempcode, "%4lX-%4lX", &tophalf, &bottomhalf) == 2) | (sscanf(tempcode, "%2lX:%6lX", &tophalf, &bottomhalf) == 2)) {
				Make9Struct(tempcode);
				if (gameflags & GOTCODE) {
					printf("%s", filechunk);
					ConvertCode();
				}
			}
			gameflags &= ~GOTCODE;
		}
	}
    }
    free(filechunk);
}
/******************************************************************/
int printEnd(void)
{
    if (!(gameflags & SUPPRESSINFO))
	printf("This program (C) Copyright 1996-1998 David McGrath\n\t\t(pat@snowfox.fur.com)\nGame Genie is a registered trademark of Lewis Galoob Toys, Inc.\n");
    return EXIT_SUCCESS;
}

/******************************************************************/
int main(int argc, char **argv)
{
    int vflag = 0;
    if (!(argc - 1)) {	/* the program name itself is the first argument */
	givehelp(argv[0]);
	exit(printEnd());
    }
#ifdef OPCODE
    while ((vflag = getopt (argc, argv, "-bcef:F:ghosvx")) != EOF) {
#else
    while ((vflag = getopt (argc, argv, "-bcf:ghsvx")) != EOF) {
#endif
	switch (vflag) {
		    case 'h':
			givehelp(argv[0]);
			break;
		    case 'v':
			givevers();
			break;
#ifdef OPCODE
		    case 'o':			/* clap on... */
			gameflags |= SHOWOPCODE;
			break;
		    case 'e':			/* clap off... */
			gameflags &= ~SHOWOPCODE;
			break;
#endif	/* OPCODE */
		    case 'b':
			gameflags |= DOFIX;
			break;
		    case 'g':
			gameflags |= FORCE_GG;
			gameflags &= ~FORCEHEX;
			break;
		    case 'x':
			gameflags |= FORCEHEX;
			gameflags &= ~FORCE_GG;
			break;
		    case 'c':
			gameflags &= ~(FORCEHEX + FORCE_GG);
			break;
		    case 'f':
#ifdef OPCODE
		    case 'F':
#endif /* OPCODE */
			{
				char *namebuf = malloc(256);
				FILE *filedata;
				strncpy(namebuf, optarg, 255);
				filedata = fopen(namebuf, "rb");
				if (errno == 2)
					printf ("Error: file %s does not exist!\n", optarg);
#ifdef OPCODE
				if (vflag == 'F')
					bitTrans(filedata);
				else
#endif
					punctGrep(filedata);
				fclose(filedata);
				free(namebuf);
			}
			break;
		    case 's':
			gameflags |= SUPPRESSINFO;
			break;
		    case 1:
			if (strlen(optarg) == 8) {
				Make8Struct(optarg);
				ConvertCode();
				break;
				}
			if (strlen(optarg) == 9) {
				Make9Struct(optarg);
				ConvertCode();
				break;
				}
			printf ("Error: Code %s mistyped?\n", optarg);
			break;
	}
    }
    return (printEnd());
}
